package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aDatosPublicaciones;

/**
 * Ab18a14s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * @author XXXX
 */
 
@Repository
@Transactional
public class Ab18aDatosPublicacionesDaoImpl implements Ab18aDatosPublicacionesDao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aDatosPublicaciones> rwMap = new RowMapper<Ab18aDatosPublicaciones>() {
		public Ab18aDatosPublicaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Ab18aDatosPublicaciones(
               resultSet.getLong("T01IDPETICIONENVIO"), resultSet.getLong("T14IDPUBLICACIONWS"), resultSet.getDate("T14FECHAPUBLICACIONWS"), resultSet.getString("T14CODDOCPUBLICACIONWS")
           ); } } ;
           
	private RowMapper<Ab18aDatosPublicaciones> rwMapPK = new RowMapper<Ab18aDatosPublicaciones>() {
		public Ab18aDatosPublicaciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aDatosPublicaciones(
				resultSet.getLong("T01IDPETICIONENVIO")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
     * @param dataSource DataSource
     * @return
     */
	private RowMapper<JerarquiaDto< Ab18aDatosPublicaciones>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aDatosPublicaciones>>() {
		public JerarquiaDto<Ab18aDatosPublicaciones> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Ab18aDatosPublicaciones ab18a14s00 = new Ab18aDatosPublicaciones(resultSet.getLong("T01IDPETICIONENVIO"), resultSet.getLong("T14IDPUBLICACIONWS"), resultSet.getDate("T14FECHAPUBLICACIONWS"), resultSet.getString("T14CODDOCPUBLICACIONWS"));

			JerarquiaDto<Ab18aDatosPublicaciones> jerarquia = new JerarquiaDto<Ab18aDatosPublicaciones>();
			jerarquia.setModel(ab18a14s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
     * Inserts a single row in the Ab18a14s00 table.
     *
     * @param ab18a14s00 Ab18a14s00
     * @return Ab18a14s00
     */
	public Ab18aDatosPublicaciones add(Ab18aDatosPublicaciones ab18a14s00) {
    	String query = "INSERT INTO AB18A14S00 (T01_ID_PETICION_ENVIO, T14_ID_PUBLICACION_WS, T14_FECHA_PUBLICACION_WS, T14_COD_DOC_PUBLICACION_WS) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, ab18a14s00.getT01IdPeticionEnvio(), ab18a14s00.getT14IdPublicacionWs(), ab18a14s00.getT14FechaPublicacionWs(), ab18a14s00.getT14CodDocPublicacionWs());
		return ab18a14s00;
	}

    /**
     * Updates a single row in the Ab18a14s00 table.
     *
     * @param ab18a14s00 Ab18a14s00
     * @return Ab18a14s00
     */
    public Ab18aDatosPublicaciones update(Ab18aDatosPublicaciones ab18a14s00) {
		String query = "UPDATE AB18A14S00 SET T14_ID_PUBLICACION_WS=?, T14_FECHA_PUBLICACION_WS=?, T14_COD_DOC_PUBLICACION_WS=? WHERE T01_ID_PETICION_ENVIO=?";
		this.jdbcTemplate.update(query, ab18a14s00.getT14IdPublicacionWs(), ab18a14s00.getT14FechaPublicacionWs(), ab18a14s00.getT14CodDocPublicacionWs(), ab18a14s00.getT01IdPeticionEnvio());
		return ab18a14s00;
	}

    /**
     * Finds a single row in the Ab18a14s00 table.
     *
     * @param ab18a14s00 Ab18a14s00
     * @return Ab18a14s00
     */
    @Transactional (readOnly = true)
    public Ab18aDatosPublicaciones find(Ab18aDatosPublicaciones ab18a14s00) {
		String query = "SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS, t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS, t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS FROM AB18A14S00 t1  WHERE t1.T01_ID_PETICION_ENVIO = ?  ";
		
		List<Ab18aDatosPublicaciones> ab18a14s00List = this.jdbcTemplate.query(query, this.rwMap, ab18a14s00.getT01IdPeticionEnvio());
		return (Ab18aDatosPublicaciones) DataAccessUtils.uniqueResult(ab18a14s00List);
    }

    /**
     * Removes a single row in the Ab18a14s00 table.
     *
     * @param ab18a14s00 Ab18a14s00
     * @return
     */
    public void remove(Ab18aDatosPublicaciones ab18a14s00) {
		String query = "DELETE FROM AB18A14S00 WHERE T01_ID_PETICION_ENVIO=?";
		this.jdbcTemplate.update(query, ab18a14s00.getT01IdPeticionEnvio());
    }
    
   /**
    * Finds a list of rows in the Ab18a14s00 table.
    * 
    * @param ab18a14s00 Ab18a14s00
    * @param jqGridRequestDto JQGridRequestDto
    * @return List<Ab18a14s00> 
    */
	@Transactional (readOnly = true)
    public List<Ab18aDatosPublicaciones> findAll(Ab18aDatosPublicaciones ab18a14s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
		query.append("FROM AB18A14S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a14s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Ab18aDatosPublicaciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Ab18a14s00 table using like.
     * 
     * @param ab18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<Ab18a14s00>
     */
	@Transactional (readOnly = true)
    public List<Ab18aDatosPublicaciones> findAllLike(Ab18aDatosPublicaciones ab18a14s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
        query.append("FROM AB18A14S00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a14s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Ab18aDatosPublicaciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
     * Counts rows in the Ab18a14s00 table.
     * 
     * @param ab18a14s00 Ab18a14s00
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Ab18aDatosPublicaciones ab18a14s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A14S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a14s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Ab18a14s00 table using like.
     * 
     * @param ab18a14s00 Ab18a14s00
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Ab18aDatosPublicaciones ab18a14s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A14S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a14s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a14s00 selected for rup_table
     * 
     * @param ab18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Ab18a14s00>> 
     */
	@Override 
	public List<TableRowDto<Ab18aDatosPublicaciones>> reorderSelection(Ab18aDatosPublicaciones ab18a14s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
		// FROM
        query.append("FROM AB18A14S00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a14s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aDatosPublicaciones.class, filterParamList, "T01_ID_PETICION_ENVIO" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aDatosPublicaciones>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
     * 
     * @param filterParams Ab18a14s00
     * @param searchParams Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean
     * @return List<TableRowDto<Ab18a14s00>> 
     */
	@Override
	public List<TableRowDto<Ab18aDatosPublicaciones>> search(Ab18aDatosPublicaciones filterParams, Ab18aDatosPublicaciones searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
		// FROM
        query.append("FROM AB18A14S00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aDatosPublicaciones.class, filterParamList, searchSQL, searchParamList, from_alias, "T01_ID_PETICION_ENVIO");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aDatosPublicaciones>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table
     * 
     * @param filterab18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean 
     */
	@Override
	public void removeMultiple(Ab18aDatosPublicaciones filterab18a14s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
		// FROM
        query.append("FROM AB18A14S00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a14s00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aDatosPublicaciones.class, query, params, "T01_ID_PETICION_ENVIO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a14s00 table.
     * 
     * @param filterAb18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<JerarquiaDto<Ab18a14s00>> 
     */
	@Override
	public List<JerarquiaDto<Ab18aDatosPublicaciones>> findAllLikeJerarquia(Ab18aDatosPublicaciones filterAb18a14s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T14_ID_PUBLICACION_WS T14IDPUBLICACIONWS,t1.T14_FECHA_PUBLICACION_WS T14FECHAPUBLICACIONWS,t1.T14_COD_DOC_PUBLICACION_WS T14CODDOCPUBLICACIONWS "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB18A14S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB18A14S00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a14s00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
     * 
     * @param filterAb18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @return Long 
     */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aDatosPublicaciones filterAb18a14s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB18A14S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB18A14S00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a14s00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
     * 
     * @param filterAb18a14s00 Ab18a14s00
     * @param jqGridRequestDto JQGridRequestDto
     * @return List<TableRowDto<Ab18a14s00>> 
     */
	@Override
	public List<TableRowDto<Ab18aDatosPublicaciones>> findAllChild(Ab18aDatosPublicaciones filterAb18a14s00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB18A14S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB18A14S00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a14s00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aDatosPublicaciones>(this.rwMapPK, "T01_ID_PETICION_ENVIO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Ab18a14s00 entity 
	 * 
	 * @param ab18a14s00 Ab18a14s00
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap (Ab18aDatosPublicaciones ab18a14s00){
		
		StringBuilder where = new StringBuilder(Ab18aDatosPublicacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a14s00  != null  && ab18a14s00.getT01IdPeticionEnvio() != null ) {
			where.append(" AND t1.T01_ID_PETICION_ENVIO = ?");
			params.add(ab18a14s00.getT01IdPeticionEnvio());
		}
		if (ab18a14s00  != null  && ab18a14s00.getT14IdPublicacionWs() != null ) {
			where.append(" AND t1.T14_ID_PUBLICACION_WS = ?");
			params.add(ab18a14s00.getT14IdPublicacionWs());
		}
		if (ab18a14s00  != null  && ab18a14s00.getT14FechaPublicacionWs() != null ) {
			where.append(" AND t1.T14_FECHA_PUBLICACION_WS = ?");
			params.add(ab18a14s00.getT14FechaPublicacionWs());
		}
		if (ab18a14s00  != null  && ab18a14s00.getT14CodDocPublicacionWs() != null ) {
			where.append(" AND t1.T14_COD_DOC_PUBLICACION_WS = ?");
			params.add(ab18a14s00.getT14CodDocPublicacionWs());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Ab18a14s00 entity 
	 * 
	 * @param ab18a14s00 Ab18a14s00
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap (Ab18aDatosPublicaciones ab18a14s00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(Ab18aDatosPublicacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a14s00  != null  && ab18a14s00.getT01IdPeticionEnvio() != null ) {
			where.append(" AND t1.T01_ID_PETICION_ENVIO = ?");
			params.add(ab18a14s00.getT01IdPeticionEnvio());
	     }			
		if (ab18a14s00  != null  && ab18a14s00.getT14IdPublicacionWs() != null ) {
			where.append(" AND t1.T14_ID_PUBLICACION_WS = ?");
			params.add(ab18a14s00.getT14IdPublicacionWs());
	     }			
		if (ab18a14s00  != null  && ab18a14s00.getT14FechaPublicacionWs() != null ) {
			where.append(" AND t1.T14_FECHA_PUBLICACION_WS = ?");
			params.add(ab18a14s00.getT14FechaPublicacionWs());
	     }			
		if (ab18a14s00  != null  && ab18a14s00.getT14CodDocPublicacionWs() != null ) {
			where.append(" AND UPPER(t1.T14_COD_DOC_PUBLICACION_WS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab18a14s00.getT14CodDocPublicacionWs().toUpperCase() +"%");
			}else{
				params.add("%"+ab18a14s00.getT14CodDocPublicacionWs().toUpperCase() +"%");
			}
			where.append(" AND t1.T14_COD_DOC_PUBLICACION_WS IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

